function [x,y,z] = rotate_plot(data,subdiv)
%This function takes a vector, and revolves it around a central axis.
%Synatax:   [x,y,z] = rotate_plot(data,100); 
%Input:     data = The vector, e.g., output for the 'hist' function.
%           subdiv = the divisions of a circle.  Default = 180
%Output:    x = the x cooridinates for the rotated data set
%           y = the y coordinates for the rotated data set
%           z = the z coordinates for the rotated data set

%make sure that data is a vertical vector
if size(data,1)==1  %horizontal vector - rotate now
    data = data';
end
%create the subdiv parameter
if nargin==1  %only one input
    if size(data,2)==1  %only the vector entered, defult circular profile
        subdiv = 180;
    else                %the data is a 2d array, use the rows as the circular profile
        subdiv = size(data,2);
    end
end

%create the coordinates
idx = [1:size(data,1)]';      %create the index
[x,y,z] = cylinder(idx,subdiv);      %use the index to create the circular profile
if size(data,2)==1      %if only a vector is entered
    z = repmat(data,1,size(x,2));        %use the data as the z axis.
end

%plot it
surfl(x,y,z)